package cktxtrdwrpkg;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.FileDialog;
import pkgmystrmngr.*;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.PrintWriter;

/**
 * <p>Title: Read/Write TextFile (Package)</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Y. Okamoto
 * @version 1.0
 */
public class FrameTxtRdWrPkg extends JFrame {
    JPanel contentPane;
    JButton jButtonGO = new JButton();
    JButton jButtonExit = new JButton();
    public FrameTxtRdWrPkg() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("Read/Write Text File (Package)");
        jButtonGO.setBounds(new Rectangle(73, 136, 71, 23));
        jButtonGO.setText("GO");
        jButtonGO.addActionListener(new FrameTxtRdWrPkg_jButtonGO_actionAdapter(this));
        jButtonExit.setBounds(new Rectangle(234, 136, 71, 23));
        jButtonExit.setText("Exit");
        jButtonExit.addActionListener(new
                                      FrameTxtRdWrPkg_jButtonExit_actionAdapter(this));
        contentPane.add(jButtonGO);
        contentPane.add(jButtonExit);
    }

    public void jButtonExit_actionPerformed(ActionEvent e) {
                  System.exit(9);
    }

    public void jButtonGO_actionPerformed(ActionEvent e) {
        FileDialog finName = new FileDialog( this, "Input File Name", FileDialog.LOAD);
        finName.show();
        FileDialog foutName = new FileDialog( this, "Output File Name", FileDialog.SAVE);
        foutName.show();

        try {
            BufferedReader fin = new BufferedReader (
                                   new FileReader ( finName.getDirectory()
                                                    + finName.getFile() )
                                 );
            PrintWriter fout = new PrintWriter(
                                 new BufferedWriter(
                                   new FileWriter( foutName.getDirectory()
                                                      + foutName.getFile() )
                                 )
                               );

            String ss = "";
            boolean ck = true;
            do {
                ss=fin.readLine();
                if (ss.length() > 0) {
                    if (ss.charAt(0) == '/') ck = false;
                }
            } while (ck);

           int x, y, z;
           String s1, s2;
           MyStrMngr fstr = new MyStrMngr();
           ck = true;
           do {
               ss = fin.readLine();
               if (ss.charAt(0) == '/') {
                   ck = false;
               }
               else {
                   x = Integer.parseInt(fstr.subStrExtr( ss, 0 ));
                   y = Integer.parseInt(fstr.subStrExtr( ss, 1 ));
                   z = Integer.parseInt(fstr.subStrExtr( ss, 2 ));
                   fout.println("   x = "+x+"   y = "+y+"   z = "+z);
               }
           } while (ck);

            fin.close();

            fout.close();
        }
        catch (Exception e1) {
            System.out.println("err: "+e1);
        }

        System.exit(0);

    }
}


class FrameTxtRdWrPkg_jButtonGO_actionAdapter implements ActionListener {
    private FrameTxtRdWrPkg adaptee;
    FrameTxtRdWrPkg_jButtonGO_actionAdapter(FrameTxtRdWrPkg adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonGO_actionPerformed(e);
    }
}


class FrameTxtRdWrPkg_jButtonExit_actionAdapter implements ActionListener {
    private FrameTxtRdWrPkg adaptee;
    FrameTxtRdWrPkg_jButtonExit_actionAdapter(FrameTxtRdWrPkg adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.jButtonExit_actionPerformed(e);
    }
}
