unit UCalcNormOrdStat;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    EditN: TEdit;
    StringGrid1: TStringGrid;
    ButtonCalc: TButton;
    ButtonClose: TButton;
    LabelMsg: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonCalcClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses Math, UPhi, UIntegral;


procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
            Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    SetPrecisionMode(pmExtended);

    EditN.Text := '5';
    with StringGrid1 do
      begin
        ColCount := 3;
        RowCount := 3;
        DefaultColWidth := 100;
        ColWidths[0] := 75;
        Cells[0,0] := 'N';
        Cells[1,0] := 'li~j';
        Cells[2,0] := 'lij';
      end;
end;


var n, k : integer;

function phi( x : extended ) : extended;
  var v : extended;
  begin
    v := exp(-0.5*sqr(x)) / sqrt(2.0*pi);
    phi := v;
  end;

function MyPower( a, b : extended ) : extended;
  var v : extended;
  begin
    v := 0.0;
    if a > 0.0  then v := b * LN(a);
    if v > -11390.0 then v := exp(v)
                    else v := 0.0;
    MyPower := v;
  end;

function F( x : extended ) : extended;
  var v : extended;
  begin
    v := x * MyPower(0.5-LPhi(x), k-1)
           * MyPower(0.5+LPhi(x), n-k)
           * phi(x);

    F := v;       
  end;


function TransF1( t : extended ) : extended;
  var v : extended;
  begin
    v := F(LN((1+t)/(1-t))) * 2.0 / (1.0-sqr(t));

    TransF1 := v;
  end;

function CalcCoEff( n, k : integer ) : extended;
  var v : extended;
      i : integer;
  begin
    v := n * 1.0;
    if k > 1 then
      for i := 1 to k-1 do v := v * (n-i) / i;
    CalcCoEff := v; 
  end;


procedure TForm1.ButtonCalcClick(Sender: TObject);
var v, coeff : extended;
    i : integer;
begin
    ButtonCalc.Enabled := false; Update;
    n := StrToInt(EditN.Text);
    if n > 400 then
      begin
        LabelMsg.Caption := 'n400ȉł';
        exit;
      end;

    StringGrid1.RowCount := n + 1;

    for i := 1 to n do
      begin
        LabelMsg.Caption := 'vZł'; UpDate;

        k := i;

        if (Odd(n) and (k = ((n+1) div 2)))
            then  v := 0.0
            else
              begin
                v := AdaptiveGL( -1.0, 1.0, TransF1 );

                coeff := CalcCoEff(n, k);
                v := coeff * v;
              end;

        with StringGrid1 do
          begin
            Cells[0,k] := IntToStr(k);
            Cells[1,k] := FloatToStrF(v,ffFixed,11,7);
            Cells[2,k] := FloatToStrF(-v,ffFixed,11,7);
          end;      
      end;

    LabelMsg.Caption := 'vZI';

    ButtonCalc.Enabled := true;
end;

end.
