unit UIntegral;

interface

type   TFunc = function( x : extended ) : extended;

function AdaptiveGL( a, b : extended;
                          f    : TFunc ) : extended;

implementation

uses Math;

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-12{-14};
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-12{-14})*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-12{-14}))
          and (abs(b-a) < 0.1)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : extended;
                          f    : TFunc ) : extended;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



end.
