unit UPhi;

interface

function LPhi( z : extended ) : extended;


implementation



{
      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                         referred to
      in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                        & Comp., 21, 447-454)
}

function  Normal_0_To_Z( z : extended ) : extended;
  label QP;
  var  p, zz, d, m, zz4, theta2,
       theta1, p_prev    : extended;
       n2                : Longint;
  begin
       z:=abs(z);
       if z > 6.8
         then
           begin
              zz:=sqr(z);
              d:=zz+3-1/(0.22*zz+0.704);
              m:=1-1/d;
              p:=0.5-exp(-0.5*zz)*m/(z*sqrt(2*pi));
           end
         else
           begin
             p:=0.0;
             if z > 0.0 then
               begin
                   zz4:=0.25*sqr(z);
                   n2:=2;       // initial value of 2n          ; n = 1
                   theta2:=1.0; // initial value of theta(2n-2)
                   theta1:=zz4; // initial value of theta(2n-1)
                   p:=1;        // sum for n = 0
                   p_prev:=0;   // initial value of sub-sum
                   while true do
                     begin
                         theta2:=zz4*(theta1-theta2)/n2;
                         n2:=n2+1;
                         p:=p+theta2/n2;
                         if p = p_prev then goto QP;
                         theta1:=zz4*(theta2-theta1)/n2;
                         n2:=n2+1;
                         p_prev:=p;
                     end;
                 QP : ;
                   p:=z*exp(-0.5*zz4)*p/sqrt(2*pi);
               end;
           end;

       if p > 0.5 then p:=0.5;

       Normal_0_To_Z:=p;
  end;   {   Normal_0_To_Z   }


function Cum_NormalKC( z : extended ) : extended;
  var  v : extended;
  begin
      if z >= 0.0
        then
          begin
            if z > 0.0
              then
                begin
                   v:=0.5+Normal_0_To_Z(z);
                   if v > 1.0 then Cum_NormalKC:=1.0
                              else Cum_NormalKC:=v;
                end
              else Cum_NormalKC:=0.5;
          end
        else
          begin
              v:=0.5-Normal_0_To_Z( abs(z) );
              if v < 0.0 then Cum_NormalKC:=0.0
                         else Cum_NormalKC:=v; 
          end;
  end;    {   Cum_NormalKC   }


function LPhi( z : extended ) : extended;
  begin
    if z >= 0.0 then LPhi := Normal_0_to_Z(z)
                else LPhi := -Normal_0_to_Z(-z);
  end;


end.
