unit UCalcFisherExctP;
//
//   W.J.Conover, 1999,
//   Practical nonparametric statistics, 3rd ed.
//   John Wiley & Sons,Inc.
//

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ButtonGO: TButton;
    ButtonClose: TButton;
    EditA: TEdit;
    EditB: TEdit;
    EditC: TEdit;
    EditD: TEdit;
    Memo1: TMemo;
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonGOClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
               Close;
end;


function CalcP( A, B, C, D : integer ) : double;
  var N, i : integer;
      v, v1 : double;
  begin
      N := A + B + C + D;
      v := 0.0;
      for i := 1 to A+B do
        v := v + LN(i);
      for i := 1 to C+D do
        v := v + LN(i);
      for i := 1 to A+C do
        v := v + LN(i);
      for i := 1 to B+D do
        v := v + LN(i);

      v1 := 0.0;
      for i := 1 to A do
        v1 := v1 + LN(i);
      for i := 1 to B do
        v1 := v1 + LN(i);
      for i := 1 to C do
        v1 := v1 + LN(i);
      for i := 1 to D do
        v1 := v1 + LN(i);
      for i := 1 to N do
        v1 := v1 + LN(i);

      v := exp(v - v1);
      CalcP := v;
  end;    

procedure TForm1.ButtonGOClick(Sender: TObject);
var A, B, C, D, N, vA, vB, vC, vD : integer;
    TwoP, Lp, Up : double;

  procedure iswap( var i, j : integer );
    var t : integer;
    begin
      t := i;  i := j;  j := t;
    end;

begin
  A := StrToInt(EditA.Text);
  B := StrToInt(EditB.Text);
  C := StrToInt(EditC.Text);
  D := StrToInt(EditD.Text);
  N := A + B + C + D;

  vA := A;  vB := B;  vC := C;  vD := D;
  Lp := 0.0;
  repeat
    Lp := Lp + CalcP( vA, vB, vC, vD );
    vA := vA - 1;  vB := vB + 1; vC := vC +1; vD := vD - 1;
  until (vA < 0) or (vD < 0);

  vA := A;  vB := B;  vC := C;  vD := D;
  Up := 0.0;
  repeat
    Up := Up + CalcP( vA, vB, vC, vD );
    vA := vA + 1;  vB := vB - 1; vC := vC -1; vD := vD + 1;
  until (vB < 0) or (vC < 0);

  if Lp < Up then TwoP := 2.0 * Lp
             else TwoP := 2.0 * Up;
  if TwoP > 1.0 then TwoP := 1.0;


  with Memo1, Lines do
     begin
       Add('');
       Add('Lower-Tailed Test:  p = ' +
            FloatToStrF(Lp,ffFixed,9,5) );
       Add('Upper-Tailed Test:  p = ' +
            FloatToStrF(Up,ffFixed,9,5) );
       Add('Two-Tailed Test:    p = ' +
            FloatToStrF(TwoP,ffFixed,9,5) );
     end;

end;

end.
