//
//              A fine resolution timer.  Y. Okamoto,  2010.03
//
#ifndef FINETIMER_CK
#define FINETIMER_CK

#include <Windows.h>

using namespace System;

namespace mytimer {

        class MyTimer {
                public:
                        LARGE_INTEGER L_I;
                        bool ck;
                        double f;
                        double c; 

                        MyTimer(): ck(false) {
                                if ( QueryPerformanceFrequency( &L_I ) ) {
                                        ck = true;
                                        c = Math::Pow(2.0, 32.0);
                                        f = L_I.LowPart + c * L_I.HighPart;
                                }
                        }

                        //      In microsecond unit
                        double time(){
                                if (ck) {
                                        QueryPerformanceCounter( &L_I );
                                        double v = L_I.HighPart * c + L_I.LowPart;
                                        return 1000000.0 * v / f;
                                } else {
                                        return 0.0;
                                }
                        }

                        //      In millisecond unit
                        int timems(){
                                return Math::Round(time() * 0.001);
                        }
        };

}

#endif
