
(*        ْl       *)   //   Yasuharu Okamoto


const   TriDiag_Zero = 1.0e-14;

type    TriDiagMat = svd_mat;
        TriDiagVctr = svd_vctr;
  

procedure  tri_diag( var  a : TriDiagMat;
                          n : Longint );
  var  act_zero, s : Extended;
       i, j        : Longint;


  procedure  mirror( i : Longint );
    var  u  : TriDiagVctr;
         j  : Longint;
         u_sqr, u_norm : Extended;
  
  
    procedure  calc_new_b( i : Longint );
      var  t  : Extended;
           j, k : Longint;
           v, p, q : TriDiagVctr;
      begin
        t:=1.0/u_norm;
        for j:=i+1 to n do
          v(.j.):=u(.j.)*t;
  
        for j:=i+1 to n do
          begin
            t:=0.0;
            for k:=i+1 to n do
              t:=t+(a(.j, k.)*v(.k.));
            p(.j.):=t;
          end;
  
        t:=0.0;
        for j:=i+1 to n do
          t:=t+(v(.j.)*p(.j.));
        for j:=i+1 to n do
          q(.j.):=2.0*(p(.j.)-(t*v(.j.)));
  
        a(.i, i+1.):=s;  a(.i+1, i.):=s;
        for j:=i+1 to n do
          for k:=j to n do
            begin
              a(.j, k.):=a(.j, k.)-(v(.j.)*q(.k.))
                                  -(q(.j.)*v(.k.));
              a(.k, j.):=a(.j, k.);
            end;
      end;   (*   calc_new_b   *)
  
  
    begin   (*   mirror   *)
      u(.i+1.):=a(.i, i+1.)-s;
      for j:=i+2 to n do
        u(.j.):=a(.i, j.);
  
      u_sqr:=2.0*s*(s-a(.i, i+1.));
      u_norm:=sqrt(u_sqr);
      if u_norm > act_zero  then calc_new_b( i );
    end;   (*   mirror   *)
  
  
  begin   (*   tri_diag   *)
    act_zero:=0.0;
    for i:=1 to n do
      for j:=i to n do
        if act_zero < abs(a(.i, j.))
          then act_zero:=abs(a(.i, j.));
    if act_zero > 0.0 then
      begin
        act_zero:=act_zero*TriDiag_Zero;
        if n >= 3 then
          for i:=1 to n-2 do
            begin
              s:=0.0;
              for j:=i+1 to n do
                s:=s+sqr(a(.i, j.));
              if a(.i, i+1.) > 0.0 then s:=-sqrt(s)
                                   else s:=sqrt(s);
              if abs(s) > (act_zero*(n-i))
                then mirror( i );
            end;
      end;
  end;   (*   tri_diag   *)
  
  
  
type    QL_mat = svd_mat;
        QL_vctr = svd_vctr;
  
const   QL_zero = 1.0e-14;
  
  
procedure  QL( var  a : QL_mat;
               n : Longint;
               var success : boolean );
  const  max_QL3 = 10000;
  var    s, c : QL_vctr;
         max_v, prac_zero : Extended;
         i, count_QL3 : Longint;
  
  
  procedure  do_QL( left, right : Longint );
    label  q_do_QL;
    var  ck_pos : Longint;
         ck_zero, ck_stop : boolean;
  
  
    procedure  QL2( left, right : Longint );
      var  v_root, b : Extended;
      begin
        v_root:=sqrt(sqr(a(.left, left.)+a(.right, right.))
                    -(4.0*((a(.left, left.)*a(.right, right.))
                          -(a(.left, right.)*a(.right, left.)))));
        b:=a(.left, left.)+a(.right, right.);
        a(.left, left.):=0.5*(b-v_root);
        a(.right, right.):=0.5*(b+v_root);
        if abs(a(.left, left.)) > abs(a(.right, right.))
          then
            begin
              b:=a(.left, left.);
              a(.left, left.):=a(.right, right.);
              a(.right, right.):=b;
            end;
        a(.left, right.):=0.0;
        a(.right, left.):=0.0;
      end;   (*   QL2   *)
  
  
    procedure  QL3( left, right : Longint );
      var  shift : Extended;
           i : Longint;
  
  
      procedure  adjust_shift;
        var  cb, cc, s1, v_root : Extended;
             i : Longint;
        begin
          cb:=-(a(.left, left.)+a(.left+1, left+1.));
          cc:=(a(.left, left.)*a(.left+1,left+1.))
              -(a(.left, left+1.)*a(.left+1, left.));
          v_root:=sqrt(sqr(cb)-(4.0*cc));
          shift:=0.5*((-cb)+v_root);
          s1:=0.5*((-cb)-v_root);
          if abs(s1) < abs(shift) then shift:=s1;
          for i:=left to right do
            a(.i, i.):=a(.i, i.)-shift;
        end;   (*   adjust_shift   *)
  
  
      procedure  make_l;
        var  k : Longint;
  
  
        procedure  q_transfm( k : Longint;
                              a1, b1, c1, a2, b2, c2 : Extended );
          var  v : Extended;
          begin
            v:=1.0/sqrt(sqr(c1)+sqr(c2));
            c(.k.):=c2*v;    s(.k.):=-c1*v;
            a(.k-1, k.):=0.0;
            a(.k, k.):=-(s(.k.)*c1)+(c(.k.)*c2);
            a(.k-1, k-1.):=(c(.k.)*b1)+(s(.k.)*b2);
            a(.k, k-1.):=-(s(.k.)*b1)+(c(.k.)*b2);
            if k > (left+1) then
              begin
                a(.k-1, k-2.):=c(.k.)*a1;
                a(.k, k-2.):=-s(.k.)*a1;
              end;
          end;   (*   q_transfm   *)
  
  
        begin   (*   make_l   *)
          for k:=right downto left+1 do
            if k > (left+1)
              then q_transfm( k, a(.k-1, k-2.), a(.k-1, k-1.),
                                 a(.k-1, k.),
                                 a(.k, k-2.), a(.k, k-1.), a(.k, k.) )
              else q_transfm( k, 0.0, a(.k-1, k-1.), a(.k-1, k.),
                                 0.0, a(.k, k-1.), a(.k, k.) );
        end;   (*   make_l   *)
  
  
      procedure  cal_lq;
        var  k : Longint;
  
  
        procedure  cal_sub_lq( k : Longint;
                               x1, x2, y1, y2 : Extended );
          begin
            a(.k-1, k-1.):=c(.k.)*x1;
            a(.k-1, k.):=-(s(.k.)*x1);
            a(.k, k-1.):=(c(.k.)*y1)+(s(.k.)*y2);
            a(.k, k.):=-(s(.k.)*y1)+(c(.k.)*y2);
          end;   (*   cal_sub_lq   *)
  
  
        begin   (*   cal_lq   *)
          for k:=right downto left+1 do
            cal_sub_lq( k, a(.k-1, k-1.),
                           a(.k-1, k.), a(.k, k-1.), a(.k, k.) );
          for k:=left+1 to right do a(.k, k-1.):=a(.k-1, k.);
        end;   (*   cal_lq   *)
  
  
      begin   (*   QL3   *)
        count_QL3:=count_QL3+1;
        if count_QL3 > max_QL3 then
          begin
            success:=false;
            writeln;
            writeln('QL3 is called too many times');
            halt;
          end;
        adjust_shift;  make_l;  cal_lq;
        for i:=left to right do
          a(.i, i.):=a(.i, i.)+shift;
      end;   (*   QL3   *)
  
  
    begin   (*   do_QL   *)
      if left < right then
        repeat
          ck_pos:=right;
          if abs(a(.ck_pos-1, ck_pos.)) < prac_zero
            then
              begin
                ck_zero:=true;
                repeat
                  ck_pos:=ck_pos-1;
                  if ck_pos > left then
                    begin
                      if abs(a(.ck_pos-1, ck_pos.)) >= prac_zero
                        then ck_zero:=false;
                    end;
                until not(ck_zero) or (ck_pos <= left);
                if not(ck_zero) then
                  begin
                    do_QL( left, ck_pos );
                    do_QL( ck_pos+1, right );
                  end;
              end
            else
              begin
                ck_zero:=false; ck_stop:=false;
                repeat
                  ck_pos:=ck_pos-1;
                  if ck_pos > left then
                    begin
                      if abs(a(.ck_pos-1, ck_pos.)) < prac_zero
                        then ck_stop:=true;
                    end;
                until (ck_pos <= left) or ck_stop;
                if ck_pos > left
                  then
                    begin
                      do_QL( left, ck_pos-1 );
                      do_QL( ck_pos, right );
                    end
                  else
                    begin
                      if right-left <= 1
                        then QL2( left, right )
                        else QL3( left, right );
                    end;
              end;
          if not( success )  then goto q_do_QL;
        until ck_zero;
  
      q_do_QL : (*   nothing   *);
    end;   (*   do_QL   *)
  
  
  begin   (*   QL   *)
    success:=true; count_QL3:=0;
    if n > 1 then
      begin
        max_v:=abs(a(.1, 1.));
        for i:=2 to n do
          begin
            if max_v < abs(a(.i, i.))
              then max_v:=abs(a(.i, i.));
            if max_v < abs(a(.i-1, i.))
              then max_v:=abs(a(.i-1, i.));
          end;
        if max_v > 0.0 then
          begin
            prac_zero:=max_v*QL_zero;  do_QL( 1, n );
          end;
      end;
  end;   (*   QL   *)
  
  
  
  
const   sw_out_zero = 1.0e-9;
  
type    sw_out_mat = svd_mat;
        sw_out_vctr = svd_vctr;
  
  
procedure  sw_out( var mat : sw_out_mat;
                   n   : Longint;
                   var solution : sw_out_vctr;
                   var  rnk : Longint );
  var  a : sw_out_mat;
       indx, z : sw_out_vctr;
       v, prac_zero, s : Extended;
       ir, ic, i_pos, c_pos, r_pos : Longint;
       chk_end : boolean;
  
  
  procedure  swap( var  a, b : Extended );
    var  v : Extended;
    begin
            v := a;   a := b;   b := v;
    end;
  
  
  procedure  sweep;
    var  ir, ic : Longint;
    begin
      if i_pos < n
        then
          begin
            if i_pos < c_pos then
              begin
                swap( indx(.i_pos.), indx(.c_pos.) );
                for ir:=1 to n do
                  swap( a(.ir, i_pos.), a(.ir, c_pos.) );
              end;
            if i_pos < r_pos then
              for ic:=i_pos to n do
                swap( a(.i_pos, ic.), a(.r_pos, ic.) );
            s:=1.0/a(.i_pos, i_pos.);
            for ic:=i_pos+1 to n do
              a(.i_pos, ic.):=a(.i_pos, ic.)*s;
            for ir:=i_pos+1 to n do
              begin
                s:=a(.ir, i_pos.);
                for ic:=i_pos+1 to n do
                  a(.ir, ic.):=a(.ir, ic.)-(s*a(.i_pos, ic.));
              end;
          end
        else
          begin
            rnk:=n;        chk_end:=true;
          end;
    end;   (*   sweep   *)
  
  
  procedure  calc_sltn;
    var  ir, ic : Longint;
    begin
      for ir:=rnk+1 to n do      z(.ir.):=1.0;
      for ir:=rnk downto 1 do
        begin
          v:=0.0;
          for ic:=ir+1 to n do
            v:=v-(a(.ir, ic.)*z(.ic.));
          z(.ir.):=v;
        end;
      s:=0.0;
      for ir:=1 to n do      s:=s+sqr(z(.ir.));
      s:=sqrt(s);      s:=1.0/s;
      for ir:=1 to n do      z(.ir.):=z(.ir.)*s;
      for ir:=1 to n do
        solution(. round(indx(.ir.)) .):=z(.ir.);
    end;   (*   calc_sltn   *)
  
  
  begin   (*   sw_out   *)
    a:=mat;
  
    v:=0.0;
    for ir:=1 to n do
      for ic:=1 to n do
        if v < abs(a(.ir, ic.))    then v:=abs(a(.ir, ic.));
    prac_zero:=sw_out_zero*v;
  
    for ic:=1 to n do  indx(.ic.):=ic;
  
    i_pos:=1; chk_end:=false;
    repeat
      c_pos:=i_pos; r_pos:=i_pos;
      v:=abs(a(.i_pos, i_pos.));
      for ir:=i_pos to n do
        for ic:=i_pos to n do
          if v < abs(a(.ir, ic.))    then
            begin
              v:=abs(a(.ir, ic.));    c_pos:=ic; r_pos:=ir;
            end;
      if v <= prac_zero
        then
          begin
            chk_end:=true;  rnk:=i_pos-1;
          end
        else
          sweep;
  
      i_pos:=i_pos+1;
    until    chk_end;
  
    if rnk >= n
      then
        begin
          for ir:=1 to n do solution(.ir.):=0.0;
        end
      else
        calc_sltn;
  end;   (*   sw_out   *)
  
  
  
const   QL_decomp_zero          = 1.0e-10;
        QL_decomp_same_accuracy = 1.0e-7;
  
type    QL_decomp_mat = svd_mat;
        QL_decomp_vctr = svd_vctr;
  
(*
  
            Spectral Decomposition
                     of
              A Symmetric Matrix
  
  
     parametrs...a    : input matrix
                 n    : size of a
                 t_n_eigen : required no. of eigen values
                 n_eigen   : actual no. of calculated eigen values
                 Lambda(.i.)       : the i th eigen value
                 eigen_vctr(.*,i.) : the i th eigen vector
*)
  
procedure  QL_decomp_1( var a : QL_decomp_mat;
                      n, t_n_eigen : Longint;
                      var  n_eigen : Longint;
                      var Lambda : QL_decomp_vctr;
                      var eigen_vctr : QL_decomp_mat );
  label  qq;
  var  b : QL_decomp_mat;
       solution : QL_decomp_vctr;
       zero_chk, ck_QL, same_Lambda : boolean;
       i, k, j, rnk, ir, ic : Longint;
       v, c_zero : Extended;
  
  
  procedure  check_zero( var  zero_chk : boolean );
    var  v : Extended;
         ir, ic : Longint;
    begin
      zero_chk:=false;
      v:=0.0;
      for ir:=1 to n do
        for ic:=1 to n do
          if v < abs(a(.ir, ic.)) then v:=abs(a(.ir, ic.));
      if v < QL_decomp_zero then
        begin  zero_chk:=true;  n_eigen:=0;  end;
    end;
  
  
  procedure  calc_c_zero( var  c_zero : Extended );
    var  v : Extended;
         ir, ic : Longint;
    begin
      v:=0.0;
      for ir:=1 to n do
        for ic:=1 to n do
          if v < abs(a(.ir, ic.))    then v:=abs(a(.ir, ic.));
      c_zero:=v*QL_decomp_zero;
    end;
  
  
  procedure  check_Lambda( var  ck : boolean );
    var  i : Longint;
    begin
      ck:=false;
      if n_eigen > 1 then
        for i:=1 to n_eigen-1 do
          if abs(Lambda(.i.)-Lambda(.i+1.)) <
            (QL_decomp_same_accuracy
              *(abs(Lambda(.i.))+abs(Lambda(.i+1.))))
               then
                 ck := true;
    end;
  
  
  begin   (*   QL_decomp_1 *)
    check_zero( zero_chk );
    if zero_chk  then goto qq;
  
    if n <= 1
      then
        begin
          if abs(a(.1, 1.)) < QL_decomp_zero
            then
                   n_eigen:=0
            else
              begin
                n_eigen:=1;
                Lambda(.1.):=a(.1, 1.);      eigen_vctr(.1, 1.):=1.0;
              end;
        end
      else
        begin
          b:=a; tri_diag( b, n );
  
          QL( b, n, ck_QL );
  
          if not ck_QL then
            begin
              writeln;
              writeln('QL failed');
              halt;
            end;
  
          for i:=1 to n-1 do
            begin
              k:=i;
              for j:=i+1 to n do
                if abs(b(.k, k.)) < abs(b(.j, j.))      then k:=j;
              if i < k then
                begin
                  v:=b(.i, i.); b(.i, i.):=b(.k, k.); b(.k, k.):=v;
                end;
            end;
  
          n_eigen:=0; calc_c_zero( c_zero );
          for i:=1 to n do
            if abs(b(.i, i.)) > c_zero
              then
                begin
                  n_eigen:=n_eigen+1;
                  Lambda(.n_eigen.):=b(.i, i.);
                end
              else
                Lambda(.i.):=0.0;
  
          check_Lambda( same_Lambda );
  
          if n_eigen > t_n_eigen  then n_eigen:=t_n_eigen;
          for i:=1 to n_eigen do
            begin
              b:=a;
              for j:=1 to n do
                b(.j, j.):=b(.j, j.)-Lambda(.i.);
  
              sw_out( b, n, solution, rnk );
  
              if rnk >= n then
                begin
                  writeln;
                  writeln('calculation accuracy error occurred.');
                  halt;
                end;
  
              for j:=1 to n do
                eigen_vctr(.j, i.):=solution(.j.);
  
              if same_Lambda then
                for ir:=1 to n do
                  for ic:=1 to n do
                    a(.ir, ic.):=a(.ir, ic.)
                                -(Lambda(.i.)*eigen_vctr(.ir, i.)
                                            *eigen_vctr(.ic, i.));
            end;
        end;
  
    qq:  (*   nothing  *) ;
  end;   (*   QL_decomp_1 *)
  
  
procedure  svd_1( var a       (*  input matrix         *)
                      : svd_mat;
                m,            (*  no. of rows of a     *)
                n             (*  no. of columns of a  *)
                      : Longint;
                var u         (*  left singular vectors   *)
                      : svd_mat;
                var Lambda    (*  vector of sigular values   *)
                      : svd_vctr;
                var  rnk      (*  no. of non-zero singular values  *)
                      : Longint;
                var v         (*  right singular vectors   *)
                      : svd_mat     );
  
  var  aa      : svd_mat;
       i, j, k : Longint;
       t       : Extended;
  begin
    if m <= n
      then   (*   a * a'   *)
        begin
          for i:=1 to m do
            for j:=i to m do
              begin
                t:=0.0;
                for k:=1 to n do
                  t:=t+(a(.i, k.)*a(.j, k.));
                aa(.i, j.):=t;
                if i < j  then aa(.j, i.):=t;
              end;
  
          QL_decomp_1( aa, m, m, rnk, Lambda, u );
  
          if rnk > 0 then
            begin
              for i:=1 to rnk do
                begin
                  Lambda(.i.):=sqrt(Lambda(.i.));
                  for j:=1 to n do
                    begin
                      t:=0.0;
                      for k:=1 to m do
                        t:=t+(a(.k, j.)*u(.k, i.));
                      v(.j, i.):=t/Lambda(.i.);
                    end;
                end;
            end;
        end
      else   (*   a' * a   *)
        begin
          for i:=1 to n do
            for j:=i to n do
              begin
                t:=0.0;
                for k:=1 to m do
                  t:=t+(a(.k, i.)*a(.k, j.));
                aa(.i, j.):=t;
                if i < j then aa(.j, i.):=t;
              end;
  
          QL_decomp_1( aa, n, n, rnk, Lambda, v );
  
          if rnk > 0 then
            begin
              for i:=1 to rnk do
                begin
                  Lambda(.i.):=sqrt(Lambda(.i.));
                  for j:=1 to m do
                    begin
                      t:=0.0;
                      for k:=1 to n do
                        t:=t+(a(.j, k.)*v(.k, i.));
                      u(.j, i.):=t/Lambda(.i.);
                    end;
                end;
            end;
        end;
  end;   (*   svd_1 *)
