unit UBiPlot;           //  Ver.1998.11.26

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TGraphF = class(TForm)
    Label1: TLabel;
    Axis1Edit: TEdit;
    Label2: TLabel;
    Axis2Edit: TEdit;
    OKButton: TButton;
    NextButton: TButton;
    ExitButton: TButton;
    PrintButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  GraphF: TGraphF;
  Image1: TImage;
  MyWidth, MyHeight,
  Lbl1T, Lbl1L, Lbl2T, Lbl2L,
  E1T, E1L, E2T, E2L, OKBT, OKBL,
  NBT, NBL, EBT, EBL   : Longint;
  VCaption : string;

implementation

{$R *.DFM}

uses  UInputCrossDual, Printers;

var   Dim1, Dim2 : Longint;

procedure TGraphF.ExitButtonClick(Sender: TObject);
begin
              InputF.Visible:=true;
              Close;
end;

//    uOKv{^̃NbNŎs
procedure TGraphF.OKButtonClick(Sender: TObject);
var x0, y0, hs,
    rs, fy, i, j, iw, ih, px, py : Longint;

  function PosX( x : Extended ) : Longint;
    begin
          PosX:=round(x0+hs*x/MaxV);
    end;

  function PosY( y : Extended ) : Longint;
    begin
          PosY:=round(y0+hs*y/MaxV);
    end;

  procedure PlotSquare( x, y : Extended;
                        id   : Longint);
    var ix, iy, w : Longint;
    begin
        ix:=PosX(x);  iy:=PosY(y);
        with Canvas do
          begin
            Pen.Width:=2; Brush.Style:=bsClear;
            Rectangle(ix-rs,iy-rs,ix+rs,iy+rs);
            w:=TextWidth(Copy(ColID[id],1,2)) div 2;
            TextOut(ix-w, iy-fy,Copy(ColID[id],1,2));
          end;
    end;

  procedure PlotCircle( x, y : Extended;
                        id   : Longint);
    var ix, iy, w : Longint;
    begin
        ix:=PosX(x);  iy:=PosY(y);
        with Canvas do
          begin
            Pen.Width:=2; Brush.Style:=bsClear;
            Ellipse(ix-rs,iy-rs,ix+rs,iy+rs);
            w:=TextWidth(Copy(RowID[id],1,2)) div 2;
            TextOut(ix-w, iy-fy,Copy(RowID[id],1,2));
          end;
    end;

begin
    WindowState:=wsMaximized;
    Color:=clWhite;
    Label1.Visible:=false;
    Axis1Edit.Visible:=false;
    Label2.Visible:=false;
    Axis2Edit.Visible:=false;
    OKButton.Visible:=false;
    with ExitButton do
      begin  Top:=0; Left:=0;  end;
    with NextButton do
      begin  Top:=0; Left:=ExitButton.Width; end;
    with PrintButton do
      begin
        Top:=0;
        Left:=NextButton.Left+NextButton.Width;
        Visible:=true;
      end;
    UpDate;

    Dim1:=StrToInt(Axis1Edit.Text);
    if Dim1 < 1 then Dim1:=1;
    if Dim1 > NDim then Dim1:=NDim;
    Dim2:=StrToInt(Axis2Edit.Text);
    if Dim2 < 1 then Dim2:=1;
    if Dim2 > NDim then Dim2:=NDim;
    with Canvas do
      begin
        x0:=ClientWidth div 2;
        y0:=ClientHeight div 2;
        hs:=round(0.8*y0);
        rs:=round(0.05*hs);
        with Font do
          begin
            Height:=round(1.2*rs);
            Name:='lr SVbN';
          end;
        fy:=round(TextHeight('X')*0.53);
        for i:=1 to nr do
          PlotCircle(wy[i,Dim1],-wy[i,Dim2],i);
        for j:=1 to nc do
          PlotSquare(wx[j,Dim1],-wx[j,Dim2],j);

        Font.Height:=2*rs;
        TextOut(x0-TextWidth('SolutionXX') div 2,
                PosY(MaxV)+2*rs,
                'Solution '+IntToStr(Dim1) );
        UpDate;

        iw:=TextWidth('SolutionXXX');
        ih:=TextHeight('SolutionXXX');
        Image1:=TImage.Create(Self);
        with Image1 do
          begin
            Visible:=false;
            Width:=iw+3;
            Height:=ih+3;
            with Canvas do
              begin
                Pen.Color:=clWhite;
                with Brush do
                  begin  Style:=bsSolid; Color:=clWhite; end;
                Rectangle(0,0,Width,Height);
                Pen.Color:=clBlack;
                Brush.Style:=bsClear;
                Font.Height:=GraphF.Canvas.Font.Height;
                Font.Name:=GraphF.Canvas.Font.Name;
                TextOut(1,1,'Solution '+IntToStr(Dim2));
              end;
          end;
        px:=PosX(-MaxV)-2*rs-ih;
        py:=y0+(iw div 2);
        for i:=0 to iw do
          for j:=0 to ih do
            Pixels[px+j,py-i]:=Image1.Canvas.Pixels[1+i,1+j];
        Image1.Free;

        Pen.Width:=1;
        Rectangle(PosX(-MaxV)-rs-3,PosY(-MaxV)-rs-3,
                  PosX( MaxV)+rs+3,PosY( MaxV)+rs+3);
      end;

    with NextButton do
      begin Enabled:=true; SetFocus; end;
end;

//    ij̑gݍ킹̍Đݒ
procedure TGraphF.NextButtonClick(Sender: TObject);
begin
    WindowState:=wsNormal;
    Height:=MyHeight;
    Width:=MyWidth;
    Position:=poScreenCenter;
    Color:=clBtnFace;
    with Label1 do
      begin  Top:=Lbl1T; Left:=Lbl1L; Visible:=true;  end;
    with Label2 do
      begin  Top:=Lbl2T; Left:=Lbl2L; Visible:=true; end;
    with Axis1Edit do
      begin  Top:=E1T;   Left:=E1L;   Visible:=true; SetFocus; end;
    with Axis2Edit do
      begin  Top:=E2T;   Left:=E2L;   Visible:=true; end;
    with OKButton do
      begin  Top:=OKBT;  Left:=OKBL;  Visible:=true; end;
    with NextButton do
      begin  Top:=NBT;   Left:=NBL;   Enabled:=false; end;
    with ExitButton do
      begin  Top:=EBT;   Left:=EBL;    end;
    with PrintButton do
      begin Caption:=VCaption; Visible:=false; end;
end;

//   BiPlot̃v^óB@uPrintv{^̃NbNŎs
procedure TGraphF.PrintButtonClick(Sender: TObject);
var x0, y0, hs,
    rs, fy, i, j, iw, ih, px, py, pw : Longint;

  function PosX( x : Extended ) : Longint;
    begin
          PosX:=round(x0+hs*x/MaxV);
    end;

  function PosY( y : Extended ) : Longint;
    begin
          PosY:=round(y0+hs*y/MaxV);
    end;

  procedure PlotSquare( x, y : Extended;
                        id   : Longint);
    var ix, iy, w : Longint;
    begin
        ix:=PosX(x);  iy:=PosY(y);
        with Printer.Canvas do
          begin
            Pen.Width:=pw; Brush.Style:=bsClear;
            Rectangle(ix-rs,iy-rs,ix+rs,iy+rs);
            w:=TextWidth(Copy(ColID[id],1,2)) div 2;
            TextOut(ix-w, iy-fy,Copy(ColID[id],1,2));
          end;
    end;

  procedure PlotCircle( x, y : Extended;
                        id   : Longint);
    var ix, iy, w : Longint;
    begin
        ix:=PosX(x);  iy:=PosY(y);
        with Printer.Canvas do
          begin
            Pen.Width:=pw; Brush.Style:=bsClear;
            Ellipse(ix-rs,iy-rs,ix+rs,iy+rs);
            w:=TextWidth(Copy(RowID[id],1,2)) div 2;
            TextOut(ix-w, iy-fy,Copy(RowID[id],1,2));
          end;
    end;
begin
    PrintDialog1.Execute;

    PrintButton.Caption:=''; UpDate;
    with Printer do
      begin
        BeginDoc;
        with Canvas do
          begin
            x0:=PageWidth div 2;
            y0:=PageHeight div 2;
            if y0 < x0 then hs:=round(0.8*y0)
                       else hs:=round(0.8*x0);
            rs:=round(0.05*hs);
            pw:=round(0.05*rs)+1;
            with Font do
              begin
                Height:=round(1.2*rs);
                Name:='lr SVbN';
              end;
            fy:=round(TextHeight('X')*0.53);
            for i:=1 to nr do
              PlotCircle(wy[i,Dim1],-wy[i,Dim2],i);
            for j:=1 to nc do
              PlotSquare(wx[j,Dim1],-wx[j,Dim2],j);

            Font.Height:=2*rs;
            TextOut(x0-TextWidth('SolutionXX') div 2,
                    PosY(MaxV)+2*rs,
                    'Solution '+IntToStr(Dim1) );

            iw:=TextWidth('SolutionXXX');
            ih:=TextHeight('SolutionXXX');
            Image1:=TImage.Create(Self);
            with Image1 do
              begin
                Visible:=false;
                Width:=iw+3;
                Height:=ih+3;
                with Canvas do
                  begin
                    Pen.Color:=clWhite;
                    with Brush do
                      begin  Style:=bsSolid; Color:=clWhite;  end;
                    Rectangle(0,0,Width,Height);
                    Pen.Color:=clBlack;
                    Brush.Style:=bsClear;
                    Font.Height:=Printer.Canvas.Font.Height;
                    Font.Name:=Printer.Canvas.Font.Name;
                    TextOut(1,1,'Solution '+IntToStr(Dim2));
                  end;
              end;
            px:=PosX(-MaxV)-2*rs-ih;
            py:=y0+(iw div 2);
            for i:=0 to iw do
              for j:=0 to ih do
                Pixels[px+j,py-i]:=Image1.Canvas.Pixels[1+i,1+j];
            Image1.Free;    

            Pen.Width:=1;
            Rectangle(PosX(-MaxV)-rs-2*pw,PosY(-MaxV)-rs-2*pw,
                      PosX( MaxV)+rs+2*pw,PosY( MaxV)+rs+2*pw);
          end;
        EndDoc;
      end;

    NextButtonClick(Self);
end;

end.
