unit UInputCrossDual;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ExtCtrls;

type
  TInputF = class(TForm)
    StringGrid1: TStringGrid;
    OKButton: TButton;
    ExitButton: TButton;
    MsgLabel: TLabel;
    Label1: TLabel;
    EditFN: TEdit;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    EditNDim: TEdit;
    SButton: TButton;
    GButton: TButton;
    SaveDialog1: TSaveDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure SButtonClick(Sender: TObject);
    procedure GButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  InputF: TInputF;

  
const MaxDim = 50;

type  svd_mat  =  array[1..MaxDim,1..MaxDim] of Extended;
      svd_vctr =  array[1..MaxDim] of Extended;


var   dfd, a, u, v, x, y, wx, wy : svd_mat;
      Lambda : svd_vctr;
      NDim, nt, nr, nc, rank : Longint;
      MaxV : Extended;
      ColID, RowID : array of string;
      CkForm : Boolean;

function IDChar( i : Longint ) : Char;


implementation

{$R *.DFM}

uses  UCrossDual, UBiPlot;


function IDChar( i : Longint ) : Char;
  begin
        case i of
            1..26 : IDChar:=Char(Ord('A')+i-1);
           27..52 : IDChar:=Char(Ord('a')+i-27);
           else     IDChar:='?';
        end;
  end;


procedure TInputF.ExitButtonClick(Sender: TObject);
begin
             MainF.Close;
end;


{$i  SVD.inc }


//   uOKv{^̃NbNŎs
procedure TInputF.OKButtonClick(Sender: TObject);
Label QP;
var outf : TextFile;
    SumSqrL, CumSqrL, ChkAsso : Extended;
    i, j, k : Longint;
    f   : array[1..MaxDim,1..MaxDim] of Longint;
    fr, fc : array[1..MaxDim] of Longint;
begin
    OKButton.Enabled:=false;
    MsgLabel.Caption:='vZn߂܂'; UpDate;

    AssignFile(outf, EditFN.Text);
    Rewrite(outf);

    NDim:=StrToInt(EditNDim.Text);

    nc:=NCol; nr:=NRow;
    with StringGrid1 do
      for i:=1 to nr do
        for j:=1 to nc do
          f[i,j]:=StrToInt(Cells[j+1,i+1]);

    SetLength(ColID, nc+1);
    for i:=1 to nc do ColID[i]:=StringGrid1.Cells[i+1, 1];
    SetLength(RowID, nr+1);
    for i:=1 to nr do RowID[i]:=StringGrid1.Cells[1, i+1];

    nt:=0;
    for i:=1 to nr do
      begin
        fr[i]:=0;
        for j:=1 to nc do
          fr[i]:=fr[i]+f[i,j];
        nt:=nt+fr[i];
      end;
    for j:=1 to nc do
      begin
        fc[j]:=0;
        for i:=1 to nr do
          fc[j]:=fc[j]+f[i,j];
      end;

    writeln(outf,'̓f[^');
    writeln(outf);
    for i:=1 to nr do
      begin
        for j:=1 to nc do
          write(outf, f[i,j]:7);
        writeln(outf);  
      end;

    ChkAsso:=0.0;
    writeln(outf);
    writeln(outf);
    writeln(outf,'Association in the Data');
    for i:=1 to nr do
      begin
        for j:=1 to nc do
          begin
            write(outf, (f[i,j]-fr[i]*fc[j]/nt):9:1);
            ChkAsso:=ChkAsso+abs(f[i,j]-fr[i]*fc[j]/nt);
          end;
        writeln(outf);
      end;
    if ChkAsso < 1.0E-5 then
      begin
        writeln(outf);
        writeln(outf,'========================================');
        writeln(outf);
        writeln(outf,'Sum of Absolute Values of Association = ',
                      ChkAsso);
        goto QP;
      end;

    for i:=1 to nr do
      for j:=1 to nc do
        dfd[i,j]:=(f[i,j]-fr[i]*fc[j]/nt)/sqrt(fr[i]*fc[j]);

    a:=dfd;
    svd_1( a, nr, nc, u, Lambda, rank, v );

    SumSqrL:=0.0;
    for k:=1 to rank do
      SumSqrL:=SumSqrL+sqr(Lambda[k]);

    CumSqrL:=0.0;  
    writeln(outf);
    writeln(outf,'            ֔̂Q               ݐ');
    for k:=1 to rank do
      begin
        CumSqrL:=CumSqrL+sqr(Lambda[k]);
        writeln(outf,'      ',k,' ==> ',sqr(Lambda[k]):10:7,
                     '        ', 100*sqr(Lambda[k])/SumSqrL:7:2,'%',
                     '   ',100*CumSqrL/SumSqrL:7:2,'%');
      end;

    if rank < NDim then
      begin
        writeln(outf);
        writeln(outf,'ݒ肵傫߂܂...NDim = ',NDim);
        NDim:=rank;
        writeln(outf,'NDim = ',NDim,' ɐݒ肵܂');
        EditNDim.Text:=IntToStr(NDim);
      end;

    for i:=1 to nr do
      for k:=1 to NDim do
        y[i,k]:=u[i,k]*sqrt(nt)/sqrt(fr[i]);
    for j:=1 to nc do
      for k:=1 to NDim do
        x[j,k]:=v[j,k]*sqrt(nt)/sqrt(fc[j]);

    writeln(outf);
    writeln(outf,'sJeS[̎ړxl');
    for i:=1 to nr do
      begin
        write(outf,'JeS[',i:2, ' (',Copy(RowID[i],1,2),')');
        for k:=1 to NDim do write(outf, y[i,k]:9:3);
        writeln(outf);
      end;

    writeln(outf);
    writeln(outf,'JeS[̎ړxl');
    for j:=1 to nc do
      begin
        write(outf,'JeS[',j:2, ' [',Copy(ColID[j],1,2),']');
        for k:=1 to NDim do write(outf, x[j,k]:9:3);
        writeln(outf);
      end;

    for k:=1 to NDim do
      begin
        for i:=1 to nr do wy[i,k]:=Lambda[k]*y[i,k];
        for j:=1 to nc do wx[j,k]:=Lambda[k]*x[j,k];
      end;

    writeln(outf);
    writeln(outf);
    writeln(outf,'sJeS[̏dݕtړxl');
    for i:=1 to nr do
      begin
        write(outf,'JeS[',i:2,' (',Copy(RowID[i],1,2),')');
        for k:=1 to NDim do write(outf, wy[i,k]:9:3);
        writeln(outf);
      end;

    writeln(outf);
    writeln(outf,'JeS[̏dݕtړxl');
    for j:=1 to nc do
      begin
        write(outf,'JeS[',j:2,' [',Copy(ColID[j],1,2),']');
        for k:=1 to NDim do write(outf, wx[j,k]:9:3);
        writeln(outf);
      end;


  QP : ;
    CloseFile(outf);
    MsgLabel.Caption:='vZI܂';
    GButton.Enabled:=true;
    ExitButton.SetFocus;
end;


function CheckCSV( s : string ) : string;
  var v : string;
  begin
    v:=s;
    if Length(v) < 5
      then v:=v+'.csv'
      else
        begin
          if ( (Copy(v, Length(s)-3, 4) <> '.csv') and
               (Copy(v, Length(s)-3, 4) <> '.CSV')    )
              then v:=v+'.csv';
        end;

    CheckCSV:=v;
  end;

//   StringGridɐݒ肳Ăf[^̕ۑ
procedure TInputF.SButtonClick(Sender: TObject);
Label QP;
var sf : TextFile;
    i, j : Longint;
begin
    with SaveDialog1 do
      begin
        Title:='f[^ۑpt@C';
        FileName:='';
        Filter:='CSVt@C(*.csv)|*.csv';
        if not Execute  then goto QP;
        AssignFile(sf, CheckCSV(FileName));
        Rewrite(sf);
      end;
    with StringGrid1 do
      for i:=1 to RowCount-1 do
        begin
          for j:=1 to ColCount-2 do
            write(sf,Cells[j,i], ',');
          writeln(sf,Cells[ColCount-1,i]);
        end;
    CloseFile(sf);
  QP :  
    ExitButton.SetFocus;
end;

//    BiPlot̕`
procedure TInputF.GButtonClick(Sender: TObject);
var   i, j, k : Longint;
begin
      Visible:=false;
      GraphF:=TGraphF.Create(Self);
      GraphF.Visible:=true;
      with GraphF do
        begin
          Position:=poScreenCenter;
          Axis1Edit.Text:='1';
          if NDim < 2 then Axis2Edit.Text:='1'
                      else Axis2Edit.Text:='2';  //  IntToStr(NDim);
          NextButton.Enabled:=false;
          Axis2Edit.SetFocus;
          UpDate;
          MyWidth:=Width;
          MyHeight:=Height;
          with Label1 do
            begin  Lbl1T:=Top; Lbl1L:=Left;  end;
          with Label2 do
            begin  Lbl2T:=Top; Lbl2L:=Left;  end;
          with Axis1Edit do
            begin  E1T:=Top;   E1L:=Left;    end;
          with Axis2Edit do
            begin  E2T:=Top;   E2L:=Left;    end;
          with OKButton do
            begin  OKBT:=Top;  OKBL:=Left;   end;
          with NextButton do
            begin  NBT:=Top;   NBL:=Left;    end;
          with ExitButton do
            begin  EBT:=Top;   EBL:=Left;    end;
          with PrintButton do
            begin VCaption:=Caption; Visible:=false; end; 
        end;

      MaxV:=0.0;
      for k:=1 to NDim do
        begin
          for i:=1 to nr do
            if MaxV < abs(wy[i,k]) then MaxV:=abs(wy[i,k]);
          for j:=1 to nc do
            if MaxV < abs(wx[j,k]) then MaxV:=abs(wx[j,k]);
        end;
end;

procedure TInputF.FormClose(Sender: TObject; var Action: TCloseAction);
begin
           if Length(ColID) > 0 then Finalize(ColID);
           if Length(RowID) > 0 then Finalize(RowID);
end;


var  CkState : integer = 0;

procedure TInputF.FormActivate(Sender: TObject);
var  i   : Longint;
     inf : TextFile;
     SL  : TStringList;
     s   : string;
begin
    if CkState = 0 then
      begin
        CkState:=1;

        if CkForm then
          begin
              with OpenDialog1 do
                begin
                  Title:='̓f[^t@C';
                  FileName:='';
                  Filter:='CSVt@C(*.csv)|*.csv';
                  Execute;
                  AssignFile(inf,FileName);
                  Reset(inf);
                end;

              //     f[^̓Ǎ
              with InputF.StringGrid1 do
                begin
                  Font.Size:=14;
                  readln(inf, s);
                  SL:=TStringList.Create;
                  SL.CommaText:=s;
                  ColCount:=SL.count+1;
                  RowCount:=2;
                  for i:=2 to ColCount-1 do
                    Cells[i,0]:='-'+IntToStr(i-1);
                  for i:=2 to ColCount-1 do
                    Cells[i,1]:=SL.Strings[i-1];

                  repeat
                    readln(inf, s);
                    SL.CommaText:=s;
                    RowCount:=RowCount+1;
                    Cells[0,RowCount-1]:='s-'+IntToStr(RowCount-2);
                    for i:=1 to ColCount-1 do
                      Cells[i,RowCount-1]:=SL.Strings[i-1];
                  until eof(inf);

                  NCol:=ColCount-2;
                  NRow:=RowCount-2;

                  SL.Free;
                  CloseFile(inf);

                  Options:=[goEditing]+Options;
                  EditorMode:=true;
                end;
          end;

        with OpenDialog1 do
          begin
            Title:='o̓t@C';
            FileName:='';
            Filter:='';
            Execute;
            EditFN.Text:=FileName;
          end;
        EditNDim.Text:='2';
      end;
end;

end.
